package gov.va.med.mhv.sm.web.formbean;

import gov.va.med.mhv.sm.api.transfer.AttachmentsTO;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class AttachmentsBean implements Serializable {
	private static final long serialVersionUID = 8L;

	// this lets us know which view is including the attachments:
	// composeMessageBean | replyMessageBean | messageViewBean
	private String theBeanImWith = "composeMessageBean";

	private AttachmentsTO attachments;

	public AttachmentsBean() {
	}

	public int getNumberOfAttachments() {
		if (attachments == null || attachments.getAttachment() == null || attachments.getAttachment().isEmpty())
			return 0;
		return attachments.getAttachment().size();
	}

	public String getTheBeanImWith() {
		return theBeanImWith;
	}

	public void setTheBeanImWith(String theBeanImWith) {
		this.theBeanImWith = theBeanImWith;
	}

	public AttachmentsTO getAttachments() {
		return attachments;
	}

	public void setAttachments(AttachmentsTO attachments) {
		this.attachments = attachments;
	}

	public boolean getShowControls() {
		return (theBeanImWith != null && (theBeanImWith.equals("composeMessageBean") || theBeanImWith.equals("replyMessageBean"))) ? true : false;
	}
	
	public Long getAttachmentId1() {
		if (attachments != null && attachments.getAttachment() != null && attachments.getAttachment().size() > 0) {
			return this.attachments.getAttachment().get(0).getId();
		} else {
			return null;
		}
	}

	public String getAttachmentName1() {
		if (attachments != null && attachments.getAttachment() != null && attachments.getAttachment().size() > 0) {
			return this.attachments.getAttachment().get(0).getName();
		} else {
			return null;
		}
	}

	public Long getAttachmentId2() {
		if (attachments != null && attachments.getAttachment() != null && attachments.getAttachment().size() > 1) {
			return this.attachments.getAttachment().get(1).getId();
		} else {
			return null;
		}
	}

	public String getAttachmentName2() {
		if (attachments != null && attachments.getAttachment() != null && attachments.getAttachment().size() > 1) {
			return this.attachments.getAttachment().get(1).getName();
		} else {
			return null;
		}
	}

	public Long getAttachmentId3() {
		if (attachments != null && attachments.getAttachment() != null && attachments.getAttachment().size() > 2) {
			return this.attachments.getAttachment().get(2).getId();
		} else {
			return null;
		}
	}

	public String getAttachmentName3() {
		if (attachments != null && attachments.getAttachment() != null && attachments.getAttachment().size() > 2) {
			return this.attachments.getAttachment().get(2).getName();
		} else {
			return null;
		}
	}

	public Long getAttachmentId4() {
		if (attachments != null && attachments.getAttachment() != null && attachments.getAttachment().size() > 3) {
			return this.attachments.getAttachment().get(3).getId();
		} else {
			return null;
		}
	}

	public String getAttachmentName4() {
		if (attachments != null && attachments.getAttachment() != null && attachments.getAttachment().size() > 3) {
			return this.attachments.getAttachment().get(3).getName();
		} else {
			return null;
		}
	}

	public void reset() {
		this.attachments = null;
		this.theBeanImWith = "composeMessageBean";
	}
}
